	function [h, ah] = HURWITZ_POLY_S(Poly)
 
	% 	Factorizes an analog polynomial into a Hurwitz and an anti-Hurwitz polynomial
	%	without any roots solving. Poly must be an even polynomial with every 
	%	other coefficient equal to zero.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
		
	%	Author: 			Lars Wanhammar 2007-08-28					
	%	Modified by: 
	%	Copyright:			by authors - not released for commercial use
	%	Version: 			1	
	%	Known bugs:			 
	%	Report bugs to:		Wanhammar@gmail.com
	
	%	Check that every other coefficient is zero. Use IS_ODD
	% 	******** Not yet implemented ********
	
	A = Poly;
	nA =length(A);
	for j = 2:2:nA
		A(j) = -A(j);
	end
	alfa = zeros(1,2*nA);
	x = zeros(1,2*nA+1);
	x(1) = sqrt(A(1));
	x(nA) = sqrt(A(nA));	
	for m = 1:100	
		for j = 2:nA-1
			alfa(j) = 0;
			for k = 1:j-1
				alfa(j) = alfa(j)+2*x(j-k)*x(j+k)*(-1)^(k+1);
			end	
			x(j) = real(sqrt(A(j)+alfa(j)));
		end	
	end
	for j = 1:length(A)/2
		n = Mod(j,2)+1;
		h(j) = x(j);
		ah(j) = x(j)*(-1)^n;
	end
